<?php namespace Visiosoft\TicketsModule\Priority;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\TicketsModule\Priority\Contract\PriorityRepositoryInterface;

class PrioritySeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run()
    {
        $priorities = [
            [
                'en' => [
                    'name' => 'High'
                ],
                'slug' => 'high',
            ],
            [
                'en' => [
                    'name' => 'normal'
                ],
                'slug' => 'normal',
            ],
            [
                'en' => [
                    'name' => 'Low'
                ],
                'slug' => 'low',
            ]
        ];
        $priorityRepository = app(PriorityRepositoryInterface::class);
        foreach ($priorities as $priority) {
            if (!$priorityRepository->newQuery()->where('slug', $priority['slug'])->whereNull('deleted_at')->orderBy('id', 'asc')->first()) {
                $priorityRepository->create($priority);
            }
        }
    }
}
