<?php namespace Visiosoft\TicketsModule\Bot;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\TicketsModule\Bot\Contract\BotRepositoryInterface;

class BotSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(BotRepositoryInterface $botRepository)
    {
        $entries = [
            [
                'name' => 'Discord Notification Bot',
                'slug' => 'discord_notification_bot'
            ]
        ];

        foreach ($entries as $entry) {
            if (!$botRepository->newQuery()->where('slug', $entry['slug'])->orderBy('id', 'desc')->first()) {
                $botRepository->create($entry);
            }
        }
    }
}
