<?php namespace Visiosoft\TicketsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\TicketModule\Listener\NewTicketEmailListener;
use Visiosoft\TicketsModule\Bot\Contract\BotRepositoryInterface;
use Visiosoft\TicketsModule\Bot\BotRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsBotsEntryModel;
use Visiosoft\TicketsModule\Bot\BotModel;
use NotificationChannels\Discord\DiscordServiceProvider;
use Visiosoft\TicketsModule\Content\Contract\ContentRepositoryInterface;
use Visiosoft\TicketsModule\Content\ContentRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsContentsEntryModel;
use Visiosoft\TicketsModule\Content\ContentModel;
use Visiosoft\TicketsModule\Supervisor\Contract\SupervisorRepositoryInterface;
use Visiosoft\TicketsModule\Supervisor\SupervisorRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsSupervisorsEntryModel;
use Visiosoft\TicketsModule\Supervisor\SupervisorModel;
use Visiosoft\TicketsModule\Priority\Contract\PriorityRepositoryInterface;
use Visiosoft\TicketsModule\Priority\PriorityRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsPrioritiesEntryModel;
use Visiosoft\TicketsModule\Priority\PriorityModel;
use Visiosoft\TicketsModule\Department\Contract\DepartmentRepositoryInterface;
use Visiosoft\TicketsModule\Department\DepartmentRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsDepartmentsEntryModel;
use Visiosoft\TicketsModule\Department\DepartmentModel;
use Visiosoft\TicketsModule\Ticket\Contract\TicketRepositoryInterface;
use Visiosoft\TicketsModule\Ticket\Event\NewTicketEmailEvent;
use Visiosoft\TicketsModule\Ticket\Event\TicketAnsweredAdminEvent;
use Visiosoft\TicketsModule\Ticket\Event\TicketAnsweredEmailEvent;
use Visiosoft\TicketsModule\Ticket\Event\TicketClosedEmailEvent;
use Visiosoft\TicketsModule\Ticket\Form\ThreadFormBuilder;
use Visiosoft\TicketsModule\Ticket\Listener\TicketAnsweredAdminEmailListener;
use Visiosoft\TicketsModule\Ticket\Listener\TicketAnsweredClientEmailListener;
use Visiosoft\TicketsModule\Ticket\Listener\TicketClosedAdminEmailListener;
use Visiosoft\TicketsModule\Ticket\Listener\TicketClosedClientEmailListener;
use Visiosoft\TicketsModule\Ticket\TicketRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsTicketsEntryModel;
use Visiosoft\TicketsModule\Ticket\TicketModel;
use Visiosoft\TicketsModule\Status\Contract\StatusRepositoryInterface;
use Visiosoft\TicketsModule\Status\StatusRepository;
use Anomaly\Streams\Platform\Model\Tickets\TicketsStatusEntryModel;
use Visiosoft\TicketsModule\Status\StatusModel;
use Illuminate\Routing\Router;

class TicketsModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'admin/tickets/bots' => 'Visiosoft\TicketsModule\Http\Controller\Admin\BotsController@index',
        'admin/tickets/bots/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\BotsController@create',
        'admin/tickets/bots/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\BotsController@edit',
        'admin/tickets' => 'Visiosoft\TicketsModule\Http\Controller\Admin\TicketsController@index',
        'admin/tickets/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\TicketsController@create',
        'admin/tickets/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\TicketsController@edit',
        'admin/tickets/contents' => 'Visiosoft\TicketsModule\Http\Controller\Admin\ContentsController@index',
        'admin/tickets/contents/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\ContentsController@create',
        'admin/tickets/contents/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\ContentsController@edit',
        'admin/tickets/supervisors' => 'Visiosoft\TicketsModule\Http\Controller\Admin\SupervisorsController@index',
        'admin/tickets/supervisors/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\SupervisorsController@create',
        'admin/tickets/supervisors/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\SupervisorsController@edit',
        'admin/tickets/priorities' => 'Visiosoft\TicketsModule\Http\Controller\Admin\PrioritiesController@index',
        'admin/tickets/priorities/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\PrioritiesController@create',
        'admin/tickets/priorities/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\PrioritiesController@edit',
        'admin/tickets/departments' => 'Visiosoft\TicketsModule\Http\Controller\Admin\DepartmentsController@index',
        'admin/tickets/departments/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\DepartmentsController@create',
        'admin/tickets/departments/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\DepartmentsController@edit',
        'admin/tickets/tickets' => 'Visiosoft\TicketsModule\Http\Controller\Admin\TicketsController@index',
        'admin/tickets/tickets/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\TicketsController@create',
        'admin/tickets/tickets/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\TicketsController@edit',
        'admin/tickets/status' => 'Visiosoft\TicketsModule\Http\Controller\Admin\StatusController@index',
        'admin/tickets/status/create' => 'Visiosoft\TicketsModule\Http\Controller\Admin\StatusController@create',
        'admin/tickets/status/edit/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\StatusController@edit',
        'admin/tickets/thread/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\TicketsController@showThread',
        'admin/tickets/close/{id}' => 'Visiosoft\TicketsModule\Http\Controller\Admin\TicketsController@close',
    ];

    protected $bindings = [
        TicketsBotsEntryModel::class => BotModel::class,
        TicketsContentsEntryModel::class => ContentModel::class,
        TicketsSupervisorsEntryModel::class => SupervisorModel::class,
        TicketsPrioritiesEntryModel::class => PriorityModel::class,
        TicketsDepartmentsEntryModel::class => DepartmentModel::class,
        TicketsTicketsEntryModel::class => TicketModel::class,
        TicketsStatusEntryModel::class => StatusModel::class,
    ];

    protected $providers = [
        DiscordServiceProvider::class,
    ];

    protected $singletons = [
        BotRepositoryInterface::class => BotRepository::class,
        'supervisor_form' => ThreadFormBuilder::class,
        ContentRepositoryInterface::class => ContentRepository::class,
        SupervisorRepositoryInterface::class => SupervisorRepository::class,
        PriorityRepositoryInterface::class => PriorityRepository::class,
        DepartmentRepositoryInterface::class => DepartmentRepository::class,
        TicketRepositoryInterface::class => TicketRepository::class,
        StatusRepositoryInterface::class => StatusRepository::class,
    ];

    public function map(Router $router)
    {
        $router->group(['prefix' => 'api'], function ($router) {
            $router->get('/tickets/auth', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@siteAuth');
            $router->group(['middleware' => 'auth:api', 'prefix' => 'tickets'], function ($router) {
                $router->get('/', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@index');
                $router->post('/', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@create');
                $router->put('/answer/{id}', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@answer');
                $router->put('/close/{id}', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@close');
                $router->get('/references', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@getReferences');
                $router->get('/{id}', 'Visiosoft\TicketsModule\Http\Controller\Api\TicketController@thread');
            });
        });
    }

    protected $listeners = [
        TicketAnsweredEmailEvent::class => [
            TicketAnsweredClientEmailListener::class
        ],
        TicketAnsweredAdminEvent::class => [
            TicketAnsweredAdminEmailListener::class
        ],
        NewTicketEmailEvent::class => [
            NewTicketEmailListener::class
        ],
        TicketClosedEmailEvent::class => [
            TicketClosedAdminEmailListener::class,
            TicketClosedClientEmailListener::class
        ]
    ];

    public function register()
    {
        config()->set('services.discord.token', env('DISCORD_BOT_TOKEN'));
    }
}
