<?php

namespace Visiosoft\TicketsModule\Ticket\Listener;

use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\TicketsModule\Bot\BotModel;
use Visiosoft\TicketsModule\Notification\DiscordNotification;
use Visiosoft\TicketsModule\Ticket\Event\TicketClosedEmailEvent;

class TicketClosedClientEmailListener
{
    private $template;

    public function __construct(TemplateRepositoryInterface $template)
    {
        $this->template = $template;
    }

    public function handle(TicketClosedEmailEvent $event)
    {
        $person = $event->getPerson();
        $ticket = $event->getTicket();
        $params = [
            'ticket_number' => '#' . $ticket->ticket_number,
            'display_name' => $person->display_name,
            'link' => config('app.url') . '/admin/tickets/thread/' . $ticket->id,
            'subject' => $ticket->subject
        ];
        $template = $this->template->findBySlug('ticket_closed_client');
        $ticket = BotModel::where('slug', 'discord_notification_bot')->first();
        $notificationParams = [
            'ticket_number' => '#' . $ticket->ticket_number,
            'user' => @$ticket->user->first_name . ' ' . @$ticket->user->last_name,
            'subject' => $ticket->subject,
            'supervisor' => @$ticket->supervisor->name,
            'link' => config('app.url') . '/admin/tickets/thread/' . $ticket->id
        ];
        $discordMessage = trans('visiosoft.module.tickets::message.ticket_closed_by_client', $notificationParams);
        $ticket->notify(new DiscordNotification($discordMessage));
        if ($template and $email = $person->email) {
            $person->notify(new MailTemplate($template->getTemplateForArray($params), $email));
        }
    }
}