<?php

namespace Visiosoft\TicketModule\Listener;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\Notification;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\NotificationsModule\Template\Notification\MailTemplate;
use Visiosoft\TicketsModule\Bot\BotModel;
use Visiosoft\TicketsModule\Notification\DiscordNotification;
use Visiosoft\TicketsModule\Ticket\Event\NewTicketEmailEvent;

class NewTicketEmailListener
{
    private $template;

    public function __construct(TemplateRepositoryInterface $templateRepository, UserRepositoryInterface $userRepository)
    {
        $this->template = $templateRepository;
        $this->userRepository = $userRepository;
    }

    public function handle(NewTicketEmailEvent $event)
    {
        $template = $this->template->findBySlug('new_ticket_opened');
        $ticket = $event->getTicket();
        $mail_params = [
            'ticket_number' => $ticket->ticket_number,
        ];
        $notificationParams = [
            'ticket_number' => '#' . $ticket->ticket_number,
            'user' => @$ticket->user->first_name . ' ' . @$ticket->user->last_name,
            'subject' => $ticket->subject,
            'supervisor' => @$ticket->supervisor->name,
            'link' => config('app.url') . '/admin/tickets/thread/' . $ticket->id
        ];
        $ticket = BotModel::where('slug', 'discord_notification_bot')->first();
        $discordMessage = trans('visiosoft.module.tickets::message.new_ticket_discord', $notificationParams);
        $ticket->notify(new DiscordNotification($discordMessage));
        if ($template) {
            Notification::send(get_admins(), new MailTemplate($template->getTemplateForArray($mail_params)));
        }
    }
}