<?php

namespace Visiosoft\TicketsModule\Ticket\Listener;

use Visiosoft\TicketsModule\Bot\BotModel;
use Visiosoft\TicketsModule\Notification\DiscordNotification;
use Visiosoft\TicketsModule\Ticket\Event\TicketAnsweredClientDiscordEvent;

class TicketAnsweredClientDiscordListener
{
    public function handle(TicketAnsweredClientDiscordEvent $event)
    {
        $ticket = $event->ticket;
        $notificationParams = [
            'ticket_number' => '#' . $ticket->ticket_number,
            'user' => !empty($ticket->user->name()) ? @$ticket->user->name() : @$ticket->user->first_name . ' ' . @$ticket->user->last_name,
            'subject' => $ticket->subject,
            'supervisor' => @$ticket->supervisor->name,
            'link' => config('app.url') . '/admin/tickets/thread/' . $ticket->id
        ];
        $bot = BotModel::where('slug', 'discord_notification_bot')->first();
        $discordMessage = trans('visiosoft.module.tickets::message.ticket_answered_by_client', $notificationParams);
        $bot->notify(new DiscordNotification($discordMessage));
    }

}