<?php namespace Visiosoft\TicketsModule\Supervisor;

use Visiosoft\TicketsModule\Supervisor\Contract\SupervisorRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class SupervisorRepository extends EntryRepository implements SupervisorRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var SupervisorModel
     */
    protected $model;

    /**
     * Create a new SupervisorRepository instance.
     *
     * @param SupervisorModel $model
     */
    public function __construct(SupervisorModel $model)
    {
        $this->model = $model;
    }

    public function getUser() {
        return $this->with(['user']);
    }
}
