<?php namespace Visiosoft\TicketsModule\Department;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\TicketsModule\Department\Contract\DepartmentRepositoryInterface;

class DepartmentSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run()
    {
        $departments = [
            [
                'en' => [
                    'name' => 'Sales'
                ],
                'slug' => 'sales'
            ],
            [
                'en' => [
                    'name' => 'Technical Support'
                ],
                'slug' => 'technical_support'
            ],
            [
                'en' => [
                    'name' => 'Accounting'
                ],
                'slug' => 'accounting'
            ]
        ];
        $departmentRepository = app(DepartmentRepositoryInterface::class);
        foreach ($departments as $department) {
            if (empty($departmentRepository->findByslug( $department['slug']))) {
                $departmentRepository->create($department);
            }
        }
    }
}
