<?php

namespace Visiosoft\TicketsModule\Notification;

use Illuminate\Notifications\Notification;
use \NotificationChannels\Discord\DiscordChannel;
use NotificationChannels\Discord\Exceptions\CouldNotSendNotification;

class DiscordSender extends DiscordChannel
{
    /**
     * Send the given notification.
     *
     * @param mixed $notifiable
     * @param Notification $notification
     *
     * @return array
     *
     * @throws CouldNotSendNotification
     */
    public function send($notifiable, Notification $notification)
    {
        if (!$channel = $notifiable->routeNotificationFor('discord', $notification)) {
            return;
        }

        $message = $notification->toDiscord($notifiable);
        return $this->discord->send($channel, [
            'content' => $message->body
        ]);
    }
}