<?php namespace Visiosoft\TenderModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\TenderModule\Governance\Contract\GovernanceRepositoryInterface;
use Visiosoft\TenderModule\Governance\GovernanceRepository;
use Anomaly\Streams\Platform\Model\Tender\TenderGovernanceEntryModel;
use Visiosoft\TenderModule\Governance\GovernanceModel;
use Visiosoft\TenderModule\Tender\Contract\TenderRepositoryInterface;
use Visiosoft\TenderModule\Tender\TenderRepository;
use Anomaly\Streams\Platform\Model\Tender\TenderTenderEntryModel;
use Visiosoft\TenderModule\Tender\TenderModel;
use Illuminate\Routing\Router;

class TenderModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'tender/{params?}'           => [
        	'as' => 'visiosoft.module.tender::home',
	        'uses' => 'Visiosoft\TenderModule\Http\Controller\TenderController@index'
        ],
	    'tender/{id}/detail' => [
	    	'as' => 'visiosoft.module.tender::detail',
		    'uses' => 'Visiosoft\TenderModule\Http\Controller\TenderController@detail',
	    ],
	    'tenders/olds' => [
		    'as' => 'visiosoft.module.tender::olds',
		    'uses' => 'Visiosoft\TenderModule\Http\Controller\TenderController@olds',
	    ],

        'admin/tender/governance'           => 'Visiosoft\TenderModule\Http\Controller\Admin\GovernanceController@index',
        'admin/tender/governance/create'    => 'Visiosoft\TenderModule\Http\Controller\Admin\GovernanceController@create',
        'admin/tender/governance/edit/{id}' => 'Visiosoft\TenderModule\Http\Controller\Admin\GovernanceController@edit',
        'admin/tender'           => 'Visiosoft\TenderModule\Http\Controller\Admin\TenderController@index',
        'admin/tender/create'    => 'Visiosoft\TenderModule\Http\Controller\Admin\TenderController@create',
        'admin/tender/edit/{id}' => 'Visiosoft\TenderModule\Http\Controller\Admin\TenderController@edit',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\TenderModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\TenderModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\TenderModule\Event\ExampleEvent::class => [
        //    Visiosoft\TenderModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\TenderModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        TenderGovernanceEntryModel::class => GovernanceModel::class,
        TenderTenderEntryModel::class => TenderModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        GovernanceRepositoryInterface::class => GovernanceRepository::class,
        TenderRepositoryInterface::class => TenderRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
