<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\LocationModule\City\CityModel;
use Visiosoft\TenderModule\Governance\GovernanceModel;

class VisiosoftModuleTenderCreateTenderFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'title' => 'anomaly.field_type.text',
        'release_date' => [
            'type' => 'anomaly.field_type.datetime',
            'config' => [
                'mode' => 'date',
            ],
        ],
        'offer_date' => [
            'type' => 'anomaly.field_type.datetime',
            'config' => [
                'mode' => 'date',
            ],
        ],
        'city' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => CityModel::class,
            ]
        ],
        'governance' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => GovernanceModel::class,
            ],
        ],
        'slug' => [
            'type' => 'anomaly.field_type.slug',
            'config' => [
                'slugify' => 'title',
                'type' => '_'
            ],
        ],
    ];

}
