<?php namespace Visiosoft\TenderModule\Tender\Form;


class TenderFormFields
{
	public function handle(TenderFormBuilder $builder)
	{
		$builder->setFields([
			'title',
			'jobs_name',
			'tags',
			'register_no',
			'release_date' => [
				'config' => [
					'default_value' => 'now',
				],
			],
			'offer_date',
			'tender_type',
			'tender_procedure',
			'tender_source',
			'tender_status',
			'governance',
			'governance_tel',
			'governance_address',
			'offer_country' => [
				'label' => 'visiosoft.module.tender::field.offer_country.name',
				'type' => 'anomaly.field_type.select',
				'config' => [
					'options' => [],
				],
			],
			'offer_city' => [
				'type' => 'anomaly.field_type.select',
				'config' => [
					'options' => [],
				],
			],
			'work_country' => [
				'type' => 'anomaly.field_type.select',
				'config' => [
					'options' => [],
				],
			],
			'work_city' => [
				'type' => 'anomaly.field_type.select',
				'config' => [
					'options' => [],
				],
			],
			'tender_notice',
			'governance_spec',
			'technic_spec',
		]);
	}
}
