<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleTenderCreateTenderFields extends Migration
{

	/**
	 * The addon fields.
	 *
	 * @var array
	 */
	protected $fields = [
		'title' => 'anomaly.field_type.text',
		'release_date' => [
			'type' => 'anomaly.field_type.datetime',
			'config' => [
				'mode' => 'date',
			],
		],
		'offer_date' => [
			'type' => 'anomaly.field_type.datetime',
			'config' => [
				'mode' => 'date',
			],
		],
		'offer_country' => [
			'type' => 'anomaly.field_type.relationship',
			'config' => [
				'related' => \Visiosoft\LocationModule\Country\CountryModel::class
			],
		],
		'offer_city' => [
			'type' => 'anomaly.field_type.relationship',
			'config' => [
				'related' => \Visiosoft\LocationModule\City\CityModel::class,
			],
		],
		'work_country' => [
			'type' => 'anomaly.field_type.relationship',
			'config' => [
				'related' => \Visiosoft\LocationModule\Country\CountryModel::class
			],
		],
		'work_city' => [
			'type' => 'anomaly.field_type.relationship',
			'config' => [
				'related' => \Visiosoft\LocationModule\City\CityModel::class,
			],
		],
		'slug' => [
			'type' => 'anomaly.field_type.slug',
			'config' => [
				'slugify' => 'title',
				'type' => '_'
			],
		],
		'jobs_name' => 'anomaly.field_type.text',
		'tags' => 'anomaly.field_type.text',
		'register_no' => 'anomaly.field_type.text',
		'tender_type' => 'anomaly.field_type.text',
		'tender_procedure' => 'anomaly.field_type.text',
		'tender_source' => 'anomaly.field_type.text',
		'tender_status' => 'anomaly.field_type.text',

		'governance' => 'anomaly.field_type.text',
		'governance_tel' => 'anomaly.field_type.text',
		'governance_address' => 'anomaly.field_type.text',
		'governance_spec' => [
			'type' => 'anomaly.field_type.file',
			'config' => [
				'folders' => ['tender_pdf'],
				'mode' => 'upload',
			]
		],
		'technic_spec' => [
			'type' => 'anomaly.field_type.file',
			'config' => [
				'folders' => ['tender_pdf'],
				'mode' => 'upload',
			]
		],
		'tender_notice' => 'anomaly.field_type.textarea',
	];

}
