<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleTenderCreateTenderStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'tender',
        'title_column' => 'title',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'release_date' => ['required' => true],
        'offer_date' => ['required' => true],
        'city' => ['required' => true],
        'title' => [
            'translatable' => true,
            'required' => true,
        ],
        'governance' => ['required' => true],
    ];

}
