<?php namespace Visiosoft\TenderModule;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Support\Facades\DB;
use Visiosoft\StoreModule\Seed\RegisterInstructionSeeder;

class TenderModuleSeeder extends Seeder
{

    protected $disks;

    protected $folders;

    public function __construct(DiskRepositoryInterface $disks, FolderRepositoryInterface $folders)
    {
        parent::__construct();

        $this->disks = $disks;
        $this->folders = $folders;
    }

    public function run()
    {
        if (!$this->folders->findBySlug('tender_pdf')) {
            $disk = $this->disks->findBySlug('local');

            $this->folders->create([
                'en' => [
                    'name' => 'Tender Pdf',
                    'description' => 'A folder for Tender PDFs.',
                ],
                'slug' => 'tender_pdf',
                'disk' => $disk,
                'allowed_types' => [
                    'pdf'
                ],
            ]);
        };
    }
}