<?php namespace Visiosoft\TenderModule\Tender;

use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\TenderModule\Tender\Contract\TenderRepositoryInterface;

class TenderRepository extends EntryRepository implements TenderRepositoryInterface
{

	/**
	 * The entry model.
	 *
	 * @var TenderModel
	 */
	protected $model;

	/**
	 * Create a new TenderRepository instance.
	 *
	 * @param TenderModel $model
	 */
	public function __construct(TenderModel $model)
	{
		$this->model = $model;
	}

	public function getNewTenders()
	{
		return $this->newQuery()
			->orderBy('offer_date', 'desc')
			->where('offer_date', '>=', now());
	}

	public function getOldTenders()
	{
		return $this->newQuery()
			->orderBy('offer_date', 'desc')
			->where('offer_date', '<=', now());
	}

	public function quickSearch($search)
	{
		$search = explode(',', $search);

		return $this->newQuery()
			->orderBy('offer_date', 'desc')
			->where('offer_date', '>=', now())
			->leftJoin('tender_tender_translations', 'tender_tender.id', 'tender_tender_translations.entry_id')
			->where(function ($query) use($search) {
				for ($i = 0; $i < count($search); $i++){
					$query->where('tender_tender.tags', 'like', '%' . $search[$i] . '%');
				}
			})
			->where('tender_tender_translations.locale', config('app.locale', 'en'));
	}

	public function detailSearch($search)
	{
		$data = $this->newQuery()->orderBy('offer_date', 'desc')
			->leftJoin('tender_tender_translations', 'tender_tender.id', 'tender_tender_translations.entry_id')
			->where('tender_tender_translations.locale', config('app.locale', 'en'));

		if ($search['order_city'] != '' and $search['order_city'] != null) {
			$data->where('offer_city_id', $search['order_city']);
		}
		if ($search['work_city'] != '' and $search['work_city'] != null) {
			$data->where('work_city_id', $search['work_city']);
		}
		if ($search['start_date'] != '' and $search['start_date'] != null) {
			$data->where('offer_date', '>=', $search['start_date']);
		}
		if ($search['finish_date'] != '' and $search['finish_date'] != null) {
			$data->where('offer_date', '<=', $search['finish_date']);
		}
		if ($search['detail_search'] != '' and $search['detail_search'] != null) {
			$data->where('tender_tender_translations.title', 'like', '%'. $search['detail_search'] .'%');
		}

		return $data;
	}
}
