getCountries()
    .then(function () {
        const selected_offer_country = typeof offer_country !== 'undefined' ? offer_country : default_country
        const selected_work_country = typeof work_country !== 'undefined' ? work_country : default_country
        if (parseInt(selected_offer_country)) {
            $('select[name="offer_country"]').val(selected_offer_country);
            getCities(selected_offer_country,'offer').then(function () {
                const selected_offer_city = typeof offer_city !== 'undefined' ? offer_city : default_city
                if (parseInt(selected_offer_city)) {
                    $('select[name="offer_city"]').val(selected_offer_city);
                }
            });
        }
        if (parseInt(selected_work_country)) {
            $('select[name="work_country"]').val(selected_work_country);
            getCities(selected_work_country,'work').then(function () {
                const selected_work_city = typeof work_city !== 'undefined' ? work_city : default_city
                if (parseInt(selected_work_city)) {
                    $('select[name="work_city"]').val(selected_work_city);
                }
            });
        }
    })

function getCountries() {
    return crudAjax('', '/ajax/getCountry', 'GET', function (callback) {
        $.each(callback, function (index, value) {
            $('select[name="offer_country"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
            $('select[name="work_country"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
        });
    }, true)
}

function getCities(country, type = '') {
    const selectsInput = type === 'offer' ? $('select[name=offer_city]') : $('select[name=work_city]');
    selectsInput.prop('disabled', true)
    selectsInput.html('<option disabled selected>Şehir seçin...</option>')
    return crudAjax(`id=${country}`, '/ajax/getCities', 'POST', () => {}, true)
        .then(function (cities) {
            $.each(cities, function (index, value) {
                type === 'offer' ? $('select[name="offer_city"]').append("<option value='" + value.id + "'>" + value.name + "</option>")
                    :  $('select[name="work_city"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
            });
            selectsInput.prop('disabled', false)
        })
}

$('select[name="offer_country"]').on('change', function () {
    getCities($(this).val(), 'offer');
});
$('select[name="work_country"]').on('change', function () {
    getCities($(this).val(), 'work');
});
