<?php namespace Visiosoft\TenderModule\Tender;

use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\TenderModule\Tender\Contract\TenderRepositoryInterface;

class TenderRepository extends EntryRepository implements TenderRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var TenderModel
     */
    protected $model;

    /**
     * Create a new TenderRepository instance.
     *
     * @param TenderModel $model
     */
    public function __construct(TenderModel $model)
    {
        $this->model = $model;
    }

    public function getNewTenders()
    {
        return $this->newQuery()->orderBy('offer_date', 'desc')->where('offer_date', '>=', now())->paginate();
    }

    public function getOldTenders()
    {
        return $this->newQuery()->orderBy('offer_date', 'desc')->where('offer_date', '<=', now())->paginate();
    }
}
