<?php


namespace Visiosoft\TenderModule\Http\Controller;


use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\TenderModule\Tender\TenderRepository;

class TenderController extends PublicController
{
    public function index(TenderRepository $tender)
    {
        $tenders = request()->tenders == 'old' ? $tender->getOldTenders() : $tender->getNewTenders();

        $date = date_format(now(), 'd/m/Y');
        $hour = date_format(now(), 'H.i');

        return $this->view->make('visiosoft.module.tender::table', compact('tenders', 'date', 'hour'));
    }
}