<?php


namespace Visiosoft\TenderModule\Http\Controller;


use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\LocationModule\City\CityModel;
use Visiosoft\LocationModule\Http\Controller\Admin\CitiesController;
use Visiosoft\LocationModule\LocationModule;
use Visiosoft\TenderModule\Tender\TenderModel;
use Visiosoft\TenderModule\Tender\TenderRepository;

class TenderController extends PublicController
{
    public function index(TenderRepository $tender, $param = null)
    {
        $tenders = request()->tenders == 'old' ? $tender->getOldTenders() : $tender->getNewTenders();

        $cities = app(CityModel::class)
	        ->where('parent_country_id', setting_value('visiosoft.module.location::default_country'))->get();

	    $date = date_format(now(), 'd.m.Y');
        $hour = date_format(now(), 'H:i');


		if ($param == 'search') {
			$search = $tender->quickSearch($this->request->search)->get();
			$tenders = $tenders->paginate(5);
			return $this->view->make('visiosoft.module.tender::table', compact('tenders', 'cities', 'search', 'date', 'hour'));
		} elseif ($param == 'detail-search') {
			$tenders = $tenders->paginate(5);
			$search = $tender->detailSearch($this->request->all())->get();
			return $this->view->make('visiosoft.module.tender::table', compact('tenders', 'cities', 'search', 'date', 'hour'));
		}

		$tenders = $tenders->paginate(5);
	    return $this->view->make('visiosoft.module.tender::table', compact('tenders', 'cities', 'date', 'hour'));
    }

    public function search(TenderRepository $tender) {
    	$search = $tender->quickSearch($this->request->search);

	    $date = date_format(now(), 'd/m/Y');
	    $hour = date_format(now(), 'H.i');

	    return $this->view->make('visiosoft.module.tender::table', compact('tenders', 'search', 'date', 'hour'));
    }

    public function detail($id){
    	$tender = TenderModel::query()->find($id);
    	return $this->view->make('visiosoft.module.tender::detail', compact('tender'));
    }

    public function olds(TenderRepository $tender){
	    $tenders = $tender->getOldTenders()->get();
	    return $this->view->make('visiosoft.module.tender::olds', compact('tenders'));
    }
}