<?php namespace Visiosoft\TcIdValidationExtension\Command;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Epigra\TcKimlik;

class ValidateFields
{
    protected $fields;

    public function __construct(array $fields)
    {
        $this->fields = $fields;
    }

    public function handle(UserRepositoryInterface $users)
    {
        if (!isset($this->fields['identification_number'])) {
            return null;
        }

        if (TcKimlik::verify($this->fields['identification_number'])) {
            return [
                'error' => false,
            ];
        } else {
            return [
                'error' => true,
                'msg' => trans('visiosoft.extension.tc_id_validation::message.tc_not_valid')
            ];
        }
    }
}
