<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSwishCreatePaymentsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'payments',
        'title_column' => 'payer',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];


    protected $fields = [
        'payer' => "anomaly.field_type.text",
        'amount' => "anomaly.field_type.decimal",
        'message' => "anomaly.field_type.text",
        'external_uid' => "anomaly.field_type.text",
        'intent_uuid' => "anomaly.field_type.text",
        'intent_token' => "anomaly.field_type.text",
        'intent_date' => "anomaly.field_type.text",
        'success_date' => "anomaly.field_type.text",
        'status' => "anomaly.field_type.integer",
        'callback_url' => "anomaly.field_type.text",
        'callback_status' => [
            'type' => "anomaly.field_type.boolean",
            'config' => [
                'default_value' => false
            ]
        ]
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'payer',
        'amount',
        'message',
        'external_uid',
        'intent_uuid',
        'intent_date',
        'success_date',
        'status',
        'callback_url',
        'callback_status',
        'intent_token'
    ];

}
