<?php namespace Visiosoft\SwishModule;

use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\Streams\Platform\Addon\Module\Module;
use Visiosoft\ConnectModule\Command\CheckRequiredParams;
use Visiosoft\SwishModule\Event\PaymentCreatedEvent;

class SwishModule extends Module
{

    /**
     * The navigation display flag.
     *
     * @var bool
     */
    protected $navigation = false;

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-puzzle-piece';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [];

    public function createPayment(array $params)
    {
        $this->dispatch(new CheckRequiredParams([
            'payment_id',
            'sender',
            'amount',
            'currency',
            'description'
        ], $params));

        $create_params = [
            'payeePaymentReference' => $params['payment_id'],
            'callbackUrl' => setting_value('visiosoft.module.swish::api_callback_url'),
            'payeeAlias' => setting_value('visiosoft.module.swish::swish_number'),
            "amount" => $params['amount'],
            "currency" => strtoupper($params['currency']),
            "message" => $params['description']
        ];

        if (!empty($params['sender'])) {
            $create_params['payerAlias'] = $params['sender'];
        }

        $resp = $this->createRequest("POST", 'v1/paymentrequests', [], json_encode($create_params));
        if ($resp->success) {
            $data['payment_id'] = $params['payment_id'];
            $data['UUID'] = str_replace($resp->data->url . "/", "", $resp->data->headers->location[0]);
            if (isset($resp->data->headers->paymentrequesttoken)) {
                $data['token'] = $resp->data->headers->paymentrequesttoken[0];
            }

            event(new PaymentCreatedEvent($data));

            return $this->sendReponse(true, $data);
        } else {
            return $this->sendReponse(false, [], $resp->message);
        }
    }

    public function getPayment(string $payment_intent_id)
    {
        $resp = $this->createRequest("GET", 'v1/paymentrequests/' . $payment_intent_id . '', []);

        return $this->sendReponse(false, $resp->data->response);
    }

    public function sendReponse($success, $data = [], $message = '')
    {
        $params = ['success' => $success, 'data' => $data, 'message' => $message];

        return json_decode(json_encode($params));
    }

    public function createRequest($method, $url, $queryString = [], $params = [])
    {
        $status = false;
        $data = [];
        $err = '';

        $base_url = setting_value("visiosoft.module.swish::api_base_url");
        $file = app(FileRepositoryInterface::class);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $base_url . $url . "?" . http_build_query($queryString));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSLCERT, $file->find(setting_value('visiosoft.module.swish::ssl_p12_file'))->url());
        curl_setopt($ch,CURLOPT_SSLCERTTYPE,"P12");
        curl_setopt($ch, CURLOPT_SSLCERTPASSWD, setting_value('visiosoft.module.swish::ssl_password'));
        if ($method == "POST") {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        }
        $headers = array();
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_HEADERFUNCTION,
            function ($curl, $header) use (&$headers) {
                $len = strlen($header);
                $header = explode(':', $header, 2);
                if (count($header) < 2) // ignore invalid headers
                    return $len;
                $headers[strtolower(trim($header[0]))][] = trim($header[1]);
                return $len;
            }
        );

        $result = json_decode(curl_exec($ch));
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if (curl_errno($ch)){
            $err = curl_error($ch);
        }

        if (isset($result[0]) && !empty($result[0]->errorCode))
        {
            $err = $result[0]->errorMessage;
        }
        curl_close($ch);

        if ($http_code == 200 || $http_code == 201) {
            $status = true;
        }

        $data['url'] = $base_url . $url;
        $data['http_code'] = $http_code;
        $data['headers'] = $headers;
        $data['response'] = $result;

        return $this->sendReponse($status, $data, $err);

    }

}
