<?php

namespace Visiosoft\SwishModule\Http\Controller;

use \Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Visiosoft\SwishModule\Event\PaymentResultEvent;

class WebhookController extends PublicController
{
    public function saveLog($values)
    {
        $file = fopen(dirname(dirname(__DIR__)) . "/logs/logs-swish-payment-result-" . time() . ".json", "w");
        fwrite($file, json_encode($values));
        fclose($file);
    }

    public function result(Request $request)
    {
        $values = $request->all();
        if (!empty($values['datePaid'])) {
            event(new PaymentResultEvent(['payment_intent_id' => $values['id'], 'success' => true]));
        }

        if (!empty($values['errorCode'])) {
            event(new PaymentResultEvent(['payment_intent_id' => $values['id'], 'success' => false]));
        }

        $this->saveLog($values);
    }
}