<?php
declare(strict_types=1);

namespace Visiosoft\SwishModule\Payment\Models;


use MyCLabs\Enum\Enum;

class PaymentStatus extends Enum
{

    /**
     * @method static self REQUEST_CREATED()
     * @method static self REQUEST_COMPLETED()
     * @method static self REQUEST_CANCELED()
     * @method static self REQUEST_FAILED()
     * @method static self REQUEST_REJECTED()
     * @method static self REQUEST_CANT_CREATED()
     */
    public const REQUEST_CREATED = 0;
    public const REQUEST_COMPLETED = 1;
    public const REQUEST_CANCELED = 2;

    public const REQUEST_FAILED = 3;
    public const REQUEST_REJECTED = 4;
    public const REQUEST_CANT_CREATED = 5;


    public static function getKeyByValue(int $value): ?string
    {
        foreach (self::toArray() as $key => $enumValue) {
            if ($enumValue === $value) {
                return $key;
            }
        }
        return null;
    }
}