<?php

namespace Visiosoft\SwishModule\Command;

use Visiosoft\SwishModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\SwishModule\Payment\Models\PaymentStatus;

class TriggerExternalHook
{
    private bool $status;

    /**
     * @param string $intentUUID
     * @param PaymentStatus $paymentStatus
     * @return bool
     */
    public function __construct(string $intentUUID, PaymentStatus $paymentStatus)
    {
        $externalWebhookUrl = setting_value('visiosoft.module.swish::external_webhook_url');
        if ($externalWebhookUrl) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $externalWebhookUrl);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['instruction_uuid' => $intentUUID, 'status' => PaymentStatus::getKeyByValue($paymentStatus->getValue())]));
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            curl_close($ch);

            if ($httpCode == 200) {
                $this->status = true;
                $intent = app(PaymentRepositoryInterface::class)->findBy('intent_uuid', $intentUUID);
                $intent->setCallbackStatus(true);
            } else {
                $this->status = false;
            }
        }
    }

    public function getStatus(): bool
    {
        return $this->status;
    }
}