<?php namespace Visiosoft\SwishModule\Payment;

use Visiosoft\SwishModule\Payment\Contract\PaymentRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\SwishModule\Payment\Models\PaymentStatus;

class PaymentRepository extends EntryRepository implements PaymentRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var PaymentModel
     */
    protected $model;

    /**
     * Create a new PaymentRepository instance.
     *
     * @param PaymentModel $model
     */
    public function __construct(PaymentModel $model)
    {
        $this->model = $model;
    }


    public function createHistory(string $payer, float $amount): \Anomaly\Streams\Platform\Model\EloquentModel
    {
        return $this->create([
            'payer' => $payer,
            'amount' => $amount,
            'intent_date' => date("Y-m-d H:i:s"),
            'status' => PaymentStatus::INTENT_CREATED
        ]);
    }
}
