<?php namespace Visiosoft\SwishModule\Payment;

use Visiosoft\SwishModule\Payment\Contract\PaymentInterface;
use Anomaly\Streams\Platform\Model\Swish\SwishPaymentsEntryModel;
use Visiosoft\SwishModule\Payment\Models\CallbackStatus;
use Visiosoft\SwishModule\Payment\Models\PaymentStatus;

class PaymentModel extends SwishPaymentsEntryModel implements PaymentInterface
{
    /**
     * @param string $payer
     * @return void
     */
    public function setPayer(string $payer): void
    {
        $this->update(['payer' => $payer]);
    }

    /**
     * @param float $amount
     * @return void
     */
    public function setAmount(float $amount): void
    {
        $this->update(['amount' => $amount]);
    }


    /**
     * @param PaymentStatus $paymentStatus
     * @return void
     */
    public function setStatus(PaymentStatus $paymentStatus): void
    {
        $statusParam = ['status' => $paymentStatus->getValue()];
        if ($paymentStatus->getValue() == PaymentStatus::INTENT_COMPLETED) {
            $statusParam['success_date'] = date("Y-m-d H:i:s");
        }

        $this->update($statusParam);
    }

    /**
     * @param string $message
     * @return void
     */
    public function setMessage(string $message): void
    {
        $this->update(['message' => $message]);
    }

    /**
     * @param string $intentUUID
     * @return void
     */
    public function setIntentUUID(string $intentUUID): void
    {
        $this->update(['intent_uuid' => $intentUUID]);
    }

    /**
     * @param string $intentToken
     * @return void
     */
    public function setIntentToken(string $intentToken): void
    {
        $this->update(['intent_token' => $intentToken]);
    }

    /**
     * @param bool $callbackStatus
     * @return void
     */
    public function setCallbackStatus(bool $callbackStatus): void
    {
        $this->update(['callback_status' => $callbackStatus]);
    }
}
