<?php
declare(strict_types=1);

namespace Visiosoft\SwishModule\Payment\Models;


use MyCLabs\Enum\Enum;

class PaymentStatus extends Enum
{

    /**
     * @method static self INTENT_CREATED()
     * @method static self INTENT_COMPLETED()
     * @method static self INTENT_CANCELED()
     * @method static self INTENT_FAILED()
     * @method static self INTENT_REJECTED()
     * @method static self INTENT_CANT_CREATED()
     */
    public const INTENT_CREATED = 0;
    public const INTENT_COMPLETED = 1;
    public const INTENT_CANCELED = 2;

    public const INTENT_FAILED = 3;
    public const INTENT_REJECTED = 4;
    public const INTENT_CANT_CREATED = 5;


    public static function getKeyByValue(int $value): ?string
    {
        foreach (self::toArray() as $key => $enumValue) {
            if ($enumValue === $value) {
                return $key;
            }
        }
        return null;
    }
}