<?php namespace Visiosoft\SwishModule\Payment\Contract;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\SwishModule\Payment\Models\CallbackStatus;
use Visiosoft\SwishModule\Payment\Models\PaymentStatus;

interface PaymentInterface extends EntryInterface
{

    /**
     * @param string $payer
     * @return void
     */
    public function setPayer(string $payer): void;

    /**
     * @param float $amount
     * @return void
     */
    public function setAmount(float $amount): void;


    /**
     * @param PaymentStatus $paymentStatus
     * @return void
     */
    public function setStatus(PaymentStatus $paymentStatus): void;

    /**
     * @param string $message
     * @return void
     */
    public function setMessage(string $message): void;

    /**
     * @param string $intentUUID
     * @return void
     */
    public function setIntentUUID(string $intentUUID): void;

    /**
     * @param string $intentToken
     * @return void
     */
    public function setIntentToken(string $intentToken): void;

    /**
     * @param bool $callbackStatus
     * @return void
     */
    public function setCallbackStatus(bool $callbackStatus): void;
}
