<?php

namespace Visiosoft\SwishModule\Job;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\SwishModule\Command\TriggerExternalHook;
use Visiosoft\SwishModule\Payment\Models\PaymentStatus;

class TriggerExternalHookJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private string $intentUUID;
    private PaymentStatus $paymentStatus;
    public int $tries;

    public function __construct($intentUUID, PaymentStatus $paymentStatus)
    {
        $this->intentUUID = $intentUUID;
        $this->paymentStatus = $paymentStatus;
        $this->tries = setting_value('visiosoft.module.swish::external_webhook_tries');
    }

    public function handle()
    {
        $isExternalWebhookActive = setting_value('visiosoft.module.swish::external_webhook');
        if ($isExternalWebhookActive) {
            $trigger = new TriggerExternalHook($this->intentUUID, $this->paymentStatus);
            if (!$trigger->getStatus()) {
                $this->release(setting_value('visiosoft.module.swish::external_webhook_interval'));
            }
        }
    }
}