<?php

namespace Visiosoft\SwishModule\Http\Controller;

use \Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Visiosoft\SwishModule\Event\PaymentResultEvent;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;

class WebhookController extends PublicController
{
    public function saveLog($values)
    {
        $fileName = "logs-swish-payment-result-" . time() . ".json";
        $log = new Logger('swish_module');
        $log->pushHandler(new StreamHandler(storage_path("logs/$fileName")), Logger::ERROR);
        $log->error(json_encode($values));
    }

    public function result(Request $request)
    {
        $values = $request->all();
        if (!empty($values['datePaid'])) {
            event(new PaymentResultEvent(['payment_intent_id' => $values['id'], 'success' => true]));
        }

        if (!empty($values['errorCode'])) {
            event(new PaymentResultEvent(['payment_intent_id' => $values['id'], 'success' => false]));
        }

        $this->saveLog($values);
    }
}
