<?php namespace Visiosoft\SwishModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\ConnectModule\Http\Middleware\AuthAdminMiddleware;
use Visiosoft\SwishModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\SwishModule\Payment\PaymentRepository;
use Anomaly\Streams\Platform\Model\Swish\SwishPaymentsEntryModel;
use Visiosoft\SwishModule\Payment\PaymentModel;
use Illuminate\Support\Facades\Route;
use Visiosoft\SwishModule\Event\PaymentResultEvent;
use Visiosoft\SwishModule\Listener\PaymentResultListener;

class SwishModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/swish' => 'Visiosoft\SwishModule\Http\Controller\Admin\PaymentsController@index',
        'admin/swish/create' => 'Visiosoft\SwishModule\Http\Controller\Admin\PaymentsController@create',
        'admin/swish/edit/{id}' => 'Visiosoft\SwishModule\Http\Controller\Admin\PaymentsController@edit',
        '/swish/webhooks/result' => '\Visiosoft\SwishModule\Http\Controller\WebhookController@result'
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\SwishModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\SwishModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        PaymentResultEvent::class => [
            PaymentResultListener::class
        ]
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\SwishModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        SwishPaymentsEntryModel::class => PaymentModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        PaymentRepositoryInterface::class => PaymentRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }


    public function map()
    {
        Route::group(['prefix' => 'admin/api/v2', 'middleware' => AuthAdminMiddleware::class], function () {
            Route::post('/swish/pay', 'Visiosoft\SwishModule\Http\Controller\Api\PaymentApiController@store');
            Route::get('/swish/pay/{instruction_uuid}', 'Visiosoft\SwishModule\Http\Controller\Api\PaymentApiController@index');
        });
    }

}
