<?php

namespace Visiosoft\SwishModule\Listener;

use Visiosoft\SwishModule\Event\PaymentResultEvent;
use Visiosoft\SwishModule\Job\TriggerExternalHookJob;
use Visiosoft\SwishModule\Payment\Contract\PaymentRepositoryInterface;
use Visiosoft\SwishModule\Payment\Models\PaymentStatus;

class PaymentResultListener
{
    public function handle(PaymentResultEvent $event)
    {
        $history = app(PaymentRepositoryInterface::class)->findBy('intent_uuid', $event->getIntentUUID());
        $paymentStatus = PaymentStatus::REQUEST_COMPLETED();
        if (!$event->getIntentStatus()) {
            $paymentStatus = PaymentStatus::REQUEST_FAILED();
        }

        $history->setStatus($paymentStatus);
        TriggerExternalHookJob::dispatch($event->getIntentUUID(), $paymentStatus);

    }
}