<?php

namespace Visiosoft\SwishModule;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;

class SwishModuleSeeder extends Seeder
{

    public function run()
    {
        $folder_repository = app(FolderRepositoryInterface::class);
        $disk_repository = app(DiskRepositoryInterface::class);

        if (is_null($folder_repository->findBy('slug', 'swish_ssl'))) {
            $disk = $disk_repository->findBySlug('local');

            $folder_repository->create([
                'en' => [
                    'name' => 'Swish Ssl Folder',
                    'description' => 'Swish Ssl Folder',
                ],
                'slug' => 'swish_ssl',
                'disk' => $disk,
            ]);
        }

    }
}