
# Swish Module

This extension provides you make payments via swish


## Methods


#### Create Payment For Web

```http
$params = [
    'payment_id' => 14727,
    'currency' => "SEK",
    'sender' => '46732392456', // If request is mobile. Please send empty
    'amount' => 100,
    'description' => "1 hour 2 minute parking price"
];

SwishModule::createPayment($params)

Returns: payment_id, UUID

```

#### Create Payment For Mobile App

```http
$params = [
    'payment_id' => 14727,
    'currency' => "SEK",
    'amount' => 100,
    'description' => "1 hour 2 minute parking price"
];

SwishModule::createPayment($params)

Returns: payment_id, UUID, token

You can use token for mobile app redirection.
Here an example: 
swish://paymentrequest?token=MFpkyoDvSPeqLvHHmU3deMUx21qGyg-b&callbackurl=https://eo7bnon1wmmiebk.m.pipedream.net' })
```


#### Get Payment

```http
$payment_intent_id = "E3ECD11FD73347A8AF5DA4C7648FDC01";
SwishModule::createPayment($payment_intent_id)
```

## Events

#### PaymentCreatedEvent
```http
Returns : payment_id, UUID
```

#### PaymentResultEvent
```http
Returns : payment_intent_id, success(boolean)
```