<?php namespace Visiosoft\SubscriptionsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Notification\SubscriptionExpired;
use Visiosoft\SubscriptionsModule\Subscription\Notification\SubscriptionRemaining;

class SubscriptionsController extends ResourceController
{
    private $subscription;

    public function __construct(SubscriptionRepositoryInterface $subscription)
    {
        $this->subscription = $subscription;
    }

    public function subscriptionControl()
    {
        $subscriptions = $this->subscription
            ->newQuery()->where('suspend_at', null)->get();
        foreach ($subscriptions as $subscription) {
            $remaining = $this->subscription->getRemaining($subscription->id, 'get');
            if (in_array($remaining, [1, 3, 5])) {
                $subscription->assign->notify(new SubscriptionRemaining($remaining, $subscription));
            } else if ($remaining == "-0") {
                $this->subscription->suspend($subscription->id);
                $subscription->assign->notify(new SubscriptionExpired($remaining, $subscription));
            }
        }
    }
}
