<?php namespace Visiosoft\SubscriptionsModule\Subscription\Form;

use Symfony\Component\HttpFoundation\Response;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\createSubscription;


class SubscriptionFormHandler
{
    public function handle(SubscriptionFormBuilder $builder)
    {

        if (!$builder->canSave()) {
            return;
        }

        $builder->saveForm();

        $subscription = $builder->getFormEntry();

        event(new createSubscription($subscription));

    }
}
