<?php namespace Visiosoft\SubscriptionsModule\Subscription\Contract;

use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;

interface SubscriptionRepositoryInterface extends EntryRepositoryInterface
{
    /**
     * @param $subscription_id
     * @return mixed
     */
    public function getRemaining($subscription_id, $type = "table");

    /**
     * @param $subscription
     * @param bool $trial
     * @return mixed
     */
    public function createdSubscription($subscription, $trial = true);

    /**
     * @param $user_id
     * @return mixed
     */
    public function findByAssign($user_id);

    /**
     * @param $id
     * @return mixed
     */
    public function suspend($id);

    /**
     * @param $id
     * @param bool $reNew
     * @return mixed
     */
    public function enabled($id, $reNew = true);
}
