<?php namespace Visiosoft\SubscriptionsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionChanged;
use Visiosoft\SubscriptionsModule\Subscription\Notification\SubscriptionExpired;
use Visiosoft\SubscriptionsModule\Subscription\Notification\SubscriptionRemaining;

class SubscriptionsController extends ResourceController
{
    private $subscription;
    private $plan;

    public function __construct(SubscriptionRepositoryInterface $subscription, PlanRepositoryInterface $plan)
    {
        $this->subscription = $subscription;
        $this->plan = $plan;
        parent::__construct();
    }

    public function subscriptionControl()
    {
        $subscriptions = $this->subscription
            ->newQuery()->where('suspend_at', null)->get();
        foreach ($subscriptions as $subscription) {
            $remaining = $this->subscription->getRemaining($subscription->id, 'get');
            if (in_array($remaining, [1, 3, 5])) {
                $subscription->assign->notify(new SubscriptionRemaining($remaining, $subscription));
            } else if ($remaining == "-0") {
                $this->subscription->suspend($subscription->id);
                $subscription->assign->notify(new SubscriptionExpired($remaining, $subscription));
            }
        }
    }

    public function listPlans()
    {
        return $this->view->make("visiosoft.module.subscriptions::list");
    }

    public function upgradePlan($id)
    {
        $plan = $this->plan->find($id);
        if (!is_null($plan) and !is_null($subscription = $this->subscription->findByAssign(Auth::id())) and $subscription->plan_id != $plan->id) {

            $response = $this->changePlanForPaddle($subscription->paddle_subscription_id, $plan->paddle_plan_id);

            if (!is_null($response)) {
                $response = json_decode($response, true);

                if ($response['success']) {

                    $new_subscription_id = $response['response']['subscription_id'];

                    $subscription->delete();

                    $subscription = $this->subscription->create([
                        'assign_id' => Auth::id(),
                        'paddle_subscription_id' => $new_subscription_id,
                        'plan_id' => $plan->id,
                        'enabled' => true
                    ]);

                    $this->subscription->createdSubscription($subscription, false);


                    $this->messages->success(trans('visiosoft.module.subscriptions::message.success_change_plan'));

                    event(new SubscriptionChanged($subscription));

                } else {
                    $this->messages->error(trans('visiosoft.module.subscriptions::message.error_change_plan'));
                }
            }
            return $this->redirect->back();
        }
        $this->messages->error(trans('visiosoft.module.subscriptions::message.found_plan'));
        return $this->redirect->back();
    }

    public function changePlanForPaddle($subscription_id, $paddle_plan_id)
    {
        $response = null;

        $params = array_merge([
            'subscription_id' => $subscription_id,
            'plan_id' => $paddle_plan_id,
            'vendor_id' => setting_value('visiosoft.module.paddle::vendor_id'),
            'vendor_auth_code' => setting_value('visiosoft.module.paddle::vendor_auth_code'),
        ]);

        $url = "https://vendors.paddle.com/api/2.0/subscription/users/update";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        curl_setopt($ch, CURLOPT_POST, 1);

        try {
            $response = curl_exec($ch);
        } catch (\Exception $exception) {
            throw new \Exception("Doğru cevap dönmedi");
        }
        curl_close($ch);

        return $response;
    }
}
