<?php namespace Visiosoft\SubscriptionsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SubscriptionsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\ExpiredSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\RemainingSubscription;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionChanged;

class SubscriptionsController extends ResourceController
{
    private $subscription;
    private $plan;
    private $site;
    private $log;

    public function __construct(
        SubscriptionRepositoryInterface $subscription,
        PlanRepositoryInterface $plan,
        SiteRepositoryInterface $site,
        LogRepositoryInterface $log)
    {
        $this->subscription = $subscription;
        $this->log = $log;
        $this->site = $site;
        $this->plan = $plan;
        parent::__construct();
    }

    public function subscriptionControl()
    {
        $subscriptions = $this->subscription->getActiveSubscriptions();

        foreach ($subscriptions as $subscription) {

            $remaining = $subscription->getRemaining();

            if (in_array((int)$remaining, [1, 3, 5])) {
                $findRemainingMail = $this->log->getFirstRemainingLog($subscription, $remaining);

                if (!$findRemainingMail) {

                    event(new RemainingSubscription($remaining, $subscription));

                    $this->log->createRemainingLog($subscription, $remaining);
                }

            } else if ($remaining < 0) {

                $findSuspendMail = $this->log->getFirstSuspendLog($subscription);

                if (!$findSuspendMail) {

                    event(new ExpiredSubscription($subscription));

                    $subscription->suspend();

                    $this->log->createSuspendLog($subscription);
                }
            }
        }
    }

    public function detail($id)
    {
        if ($subscription = $this->subscription->find($id)) {
            return $this->view->make('visiosoft.module.subscriptions::subscriptions.detail', compact('subscription'));
        }
        $this->messages->error(trans('visiosoft.module.subscriptions::message.found_subscriptions'));

        return $this->redirect->route('visiosoft.module.subscriptions::my-subscriptions');
    }

    public function changePlanForPaddle($subscription_id, $paddle_plan_id)
    {
        $response = null;

        $params = array_merge([
            'subscription_id' => $subscription_id,
            'plan_id' => $paddle_plan_id,
            'vendor_id' => setting_value('visiosoft.module.paddle::vendor_id'),
            'vendor_auth_code' => setting_value('visiosoft.module.paddle::vendor_auth_code'),
        ]);

        $url = "https://vendors.paddle.com/api/2.0/subscription/users/update";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        curl_setopt($ch, CURLOPT_POST, 1);

        try {
            $response = curl_exec($ch);
        } catch (\Exception $exception) {
            $this->messages->error([$exception->getMessage()]);
        }
        curl_close($ch);

        return $response;
    }


    public function mySubscriptions()
    {
        return $this->view->make('visiosoft.module.subscriptions::subscriptions.list');
    }

    public function renew($id)
    {
        if ($subscription = $this->subscription->find($id)) {
            $plans = $this->plan->newQuery()->get();
            return $this->view->make('visiosoft.module.subscriptions::plan.upgrade', compact('plans', 'subscription'));
        }
        abort(404);
    }
}
