<?php namespace Visiosoft\SubscriptionsModule\Plan;

use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class PlanRepository extends EntryRepository implements PlanRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var PlanModel
     */
    protected $model;

    /**
     * Create a new PlanRepository instance.
     *
     * @param PlanModel $model
     */
    public function __construct(PlanModel $model)
    {
        $this->model = $model;
    }

    /**
     * @param $id
     * @return mixed
     * find Plan or return default plan
     */
    public function findByPaddle($id)
    {
        $default_plan = setting_value('visiosoft.module.subscriptions::register_default_plan');

        if (count($plan = $this->model->where('paddle_plan_id', $id)->get())) {
            return $plan->first();
        }
        return $this->find($default_plan);
    }
}
