<?php namespace Visiosoft\SubscriptionsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\EntryModel;
use Anomaly\UsersModule\User\UserRepository;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Form\SubscriptionFormBuilder;
use Visiosoft\SubscriptionsModule\Subscription\Table\SubscriptionTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class SubscriptionsController extends AdminController
{

    /**
     * @var SubscriptionRepositoryInterface
     */
    private $repository;
    /**
     * @var SiteRepositoryInterface
     */
    private $site;
    /**
     * @var UserRepository
     */
    private $user;

    /**
     * SubscriptionsController constructor.
     * @param SubscriptionRepositoryInterface $repository
     * @param SiteRepositoryInterface $site
     */
    public function __construct(
        SubscriptionRepositoryInterface $repository,
        SiteRepositoryInterface $site,
        UserRepository $user
    )
    {
        $this->repository = $repository;
        $this->site = $site;
        $this->user = $user;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param SubscriptionTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(SubscriptionTableBuilder $table)
    {
        $table->setColumns([
            'assign',
            'plan',
            'trial_expires_at',
            'expires_at',
            'remaining_time' => [
                'value' => function (EntryModel $entry) {
                    if ($entry->suspend_at) {
                        return "<font color='red'>" . trans('visiosoft.module.subscriptions::message.suspended') . "</font>";
                    }
                    return $this->repository->getRemaining($entry->id);
                }
            ],
        ]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param SubscriptionFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(SubscriptionFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param SubscriptionFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(SubscriptionFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
