<?php namespace Visiosoft\SubscriptionsModule\Subscription\Listener\site;

use Carbon\Carbon;
use Visiosoft\SiteModule\Site\Event\ExtendSite;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;

class ExtendSubscribe
{
    private $subscription;

    public function __construct(SubscriptionRepositoryInterface $subscription)
    {
        $this->subscription = $subscription;
    }

    public function handle(ExtendSite $event)
    {
        $subscription_id = $event->getSubscriptionID();

        if ($subscription = $this->subscription->find($subscription_id)) {
            $subscription->setAttribute('trial_expires_at', Carbon::now()->addDays($event->days()));
            $subscription->setAttribute('expires_at', Carbon::now()->addDays($event->days()));
            $subscription->save();
        }
    }
}
