<?php namespace Visiosoft\SubscriptionsModule\Subscription\Listener\paddle;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\PaddleModule\Event\SubscriptionPaymentSucceededPaddle;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionCreated;

class SubscriptionPaymentSucceeded
{
    private $plan;
    private $user;
    private $subscription;

    public function __construct(
        PlanRepositoryInterface $plan,
        UserRepositoryInterface $user,
        SubscriptionRepositoryInterface $subscription)
    {
        $this->plan = $plan;
        $this->user = $user;
        $this->subscription = $subscription;
    }

    public function handle(SubscriptionPaymentSucceededPaddle $event)
    {
        $subscription_created = $event->getResponse();

        if (!is_null($plan = $this->plan->findByPaddle($subscription_created['subscription_plan_id']))
            and
            !is_null($user = $this->user->findByEmail($subscription_created['email']))) {

            if (is_null($subscription = $this->subscription->findByAssign($user->getId()))) {
                //New Subscription
                $subscription = $this->subscription->create([
                    'assign_id' => $user->getId(),
                    'plan_id' => $plan->id,
                    'enabled' => true
                ]);
                $entry = event(new SubscriptionCreated($subscription));

                if (!is_null($entry) and is_array($entry)) {
                    $this->subscription->update([
                        'entry' => array_first($entry)
                    ]);
                }
                $this->subscription->enabled($subscription->id, false);

            } else {
                //Renew Subscription
                $this->subscription->enabled($subscription->id);
            }


            $trial = false;
            if ($subscription_created['status'] == "trialing") {
                $trial = true;
            }
            $this->subscription->createdSubscription($subscription, $trial);
        }

    }
}
