<?php namespace Visiosoft\SubscriptionsModule\Subscription\Listener\paddle;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\PaddleModule\Event\SubscriptionPaymentFailedPaddle;
use Visiosoft\SubscriptionsModule\Plan\Contract\PlanRepositoryInterface;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;

class SubscriptionPaymentFailed
{
    private $plan;
    private $user;
    private $subscription;

    public function __construct(
        PlanRepositoryInterface $plan,
        UserRepositoryInterface $user,
        SubscriptionRepositoryInterface $subscription)
    {
        $this->plan = $plan;
        $this->user = $user;
        $this->subscription = $subscription;
    }

    public function handle(SubscriptionPaymentFailedPaddle $event)
    {
        $subscription_created = $event->getResponse();

        if (!is_null($user = $this->user->findByEmail($subscription_created['email']))
            and !is_null($subscription = $this->subscription->findByAssign($user->getId()))) {

            $this->subscription->suspend($subscription->id);
        }

    }
}
