<?php namespace Visiosoft\SubscriptionsModule\Subscription\Event;

use Visiosoft\SiteModule\Site\SiteModel;
use Visiosoft\SiteModule\Site\SiteRepository;
use Visiosoft\SubscriptionsModule\Plan\PlanModel;

class SubscriptionRemaining
{
    /**
     * @author Visiosoft LTD.
     */
    private $subscription;
    private $remaining;
    private $sites;

    /**
     * SubscriptionChanged constructor.
     * @param $subscription
     */
    public function __construct($remaining, $subscription, $sites)
    {
        $this->subscription = $subscription;
        $this->remaining = $remaining;
        $this->sites = $sites;
    }

    /**
     * @return mixed
     */
    public function getSubscription()
    {
        return $this->subscription;
    }

    public function getPlan()
    {
        $plan = new PlanModel();
        return $plan->newQuery()->find($this->getSubscription()->plan_id);
    }

    public function getRemaining()
    {
        return $this->remaining;
    }

    public function getSites()
    {
        return $this->sites;
    }
}
