<?php namespace Visiosoft\SubscriptionsModule\Subscription\Event;

use Visiosoft\SubscriptionsModule\Plan\PlanModel;

class SubscriptionExpired
{
    /**
     * @author Visiosoft LTD.
     */
    private $subscription;
    private $sites;

    /**
     * SubscriptionChanged constructor.
     * @param $subscription
     */
    public function __construct($subscription, $sites)
    {
        $this->subscription = $subscription;
        $this->sites = $sites;
    }

    /**
     * @return mixed
     */
    public function getSubscription()
    {
        return $this->subscription;
    }

    public function getPlan()
    {
        $plan = new PlanModel();
        return $plan->newQuery()->find($this->getSubscription()->plan_id);
    }

    public function getSites()
    {
        return $this->sites;
    }
}
