<?php namespace Visiosoft\SubscriptionsModule\Log;

use Visiosoft\SubscriptionsModule\Log\Contract\LogRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class LogRepository extends EntryRepository implements LogRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var LogModel
     */
    protected $model;

    /**
     * Create a new LogRepository instance.
     *
     * @param LogModel $model
     */
    public function __construct(LogModel $model)
    {
        $this->model = $model;
    }

    public function findLogForParams($params)
    {
        $query = $this->newQuery();
        foreach ($params as $column => $value) {
            $query = $query->where($column, $value);
        }
        return $query->first();
    }
}
