<?php namespace Visiosoft\SubscriptionsModule\Subscription\Notification;

use Anomaly\Streams\Platform\Notification\Message\MailMessage;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class SubscriptionRemaining extends Notification implements ShouldQueue
{

    use Queueable;

    public $subscription;
    public $remaining;

    public function __construct($remaining, $subscription)
    {
        $this->subscription = $subscription;
        $this->remaining = $remaining;
    }

    public function via()
    {
        return ['mail'];
    }

    public function toMail()
    {
        return (new MailMessage())
            ->view('visiosoft.theme.base::notifications.email')
            ->subject(trans('visiosoft.module.subscriptions::message.remaining_notification.subject', ['remaining' => $this->remaining]))
            ->line(trans('visiosoft.module.subscriptions::message.remaining_notification.line1',
                ['remaining' => $this->remaining, 'plan' => ucfirst($this->subscription->plan->name)]))
            ->line(trans('visiosoft.module.subscriptions::message.remaining_notification.line2'))
            ->line(trans('visiosoft.module.subscriptions::message.remaining_notification.line3'))
            ->salutation(trans('visiosoft.module.subscriptions::message.notification.salutation'));
    }
}
